' Ordnerauswahl mit Ausgabe in Textdatei + Startpfad als Parameter
Option Explicit

Dim objShell, objFolder, strFolder
Dim objFSO, objFile
Dim startPfad, ausgabeDatei

' --- Ausgabedatei fix ---
ausgabeDatei = "C:\Temp\Ordner.txt"

' --- Standard-Startpfad ---
startPfad = "C:\Daten\Dropbox\_Kunden_Dropbox\Gleich\fq.prg\Bloecke"

' --- Startpfad per Parameter berschreiben ---
If WScript.Arguments.Count > 0 Then
    startPfad = WScript.Arguments.Item(0)
End If

' --- FileSystemObject ---
Set objFSO = CreateObject("Scripting.FileSystemObject")

' --- Ausgabedatei beim Start lschen ---
If objFSO.FileExists(ausgabeDatei) Then
    objFSO.DeleteFile ausgabeDatei, True
End If

' --- Zielordner der Ausgabedatei sicherstellen ---
If Not objFSO.FolderExists(objFSO.GetParentFolderName(ausgabeDatei)) Then
    objFSO.CreateFolder objFSO.GetParentFolderName(ausgabeDatei)
End If

' --- Shell starten und Ordnerdialog ffnen ---
Set objShell = CreateObject("Shell.Application")
Set objFolder = objShell.BrowseForFolder(0, "Bitte Ordner auswhlen:", 0, startPfad)

If Not objFolder Is Nothing Then
    ' OK
    strFolder = objFolder.Self.Path
    Set objFile = objFSO.CreateTextFile(ausgabeDatei, True)
    objFile.WriteLine strFolder
    objFile.Close
Else
    ' Abbruch
    Set objFile = objFSO.CreateTextFile(ausgabeDatei, True)
    objFile.WriteLine "Abbruch"
    objFile.Close
End If
